/*  LOOT

    A load order optimisation tool for
    Morrowind, Oblivion, Skyrim, Skyrim Special Edition, Skyrim VR,
    Fallout 3, Fallout: New Vegas, Fallout 4 and Fallout 4 VR.

    Copyright (C) 2021    Oliver Hamlet

    This file is part of LOOT.

    LOOT is free software: you can redistribute
    it and/or modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation, either version 3 of
    the License, or (at your option) any later version.

    LOOT is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LOOT.  If not, see
    <https://www.gnu.org/licenses/>.
    */

#ifndef LOOT_GUI_QT_STYLE
#define LOOT_GUI_QT_STYLE

#include <QtCore/QString>
#include <filesystem>
#include <optional>
#include <string>
#include <vector>

namespace loot {
constexpr std::string_view DARK_THEME_SUFFIX = "-dark";
constexpr std::string_view LIGHT_THEME_SUFFIX = "-light";

std::optional<QString> loadStyleSheet(const std::filesystem::path& themesPath,
                                      const std::string& themeName);

std::vector<std::string> findThemes(const std::filesystem::path& themesPath);
}

#endif
